#region References

using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Reflection;
using System.Text;
using System.Windows.Forms;

using gov.va.med.vbecs.BOL;
using gov.va.med.vbecs.Common;

using VBECSDateTime = gov.va.med.vbecs.BOL.VBECSDateTime;
using ListViewSubItem = System.Windows.Forms.ListViewItem.ListViewSubItem;

#endregion

namespace gov.va.med.vbecs.GUI
{
	#region Header

	//<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	//<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	//<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	//<Developers>
	//	<Developer>Margaret Jablonski</Developer>
	//</Developers>
	//<SiteName>Hines OIFO</SiteName>
	//<CreationDate>7/13/2004</CreationDate>
	//<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	//<summary></summary>

	#endregion

	/// <summary>
	/// Class FrmViewUpdatedPatients
	/// </summary>
	public class FrmViewUpdatedPatients : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		#region Delegates
		
		private event EventHandler onViewedUpdates;

		#endregion

		#region Controls

		private System.Windows.Forms.GroupBox grpPatients;
		private System.Windows.Forms.ListView lvPatients;
		private System.Windows.Forms.ColumnHeader columnHeader1;
		private System.Windows.Forms.ColumnHeader columnHeader2;
		private System.Windows.Forms.ColumnHeader columnHeader3;
		private System.Windows.Forms.ColumnHeader columnHeader4;
		private System.Windows.Forms.Button btnClose;
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.PictureBox picImage;
		private System.Windows.Forms.ColumnHeader columnHeader5;
		private System.Windows.Forms.ColumnHeader columnHeader6;
		private System.Windows.Forms.ColumnHeader columnHeader7;
		private System.Windows.Forms.Label lblDeceasedPatients;
		private System.Windows.Forms.ColumnHeader columnHeader8;
		private System.Windows.Forms.ColumnHeader columnHeader9;
		private System.Windows.Forms.ColumnHeader columnHeader10;
		private System.Windows.Forms.ColumnHeader columnHeader11;
		private System.ComponentModel.IContainer components = null;

		#endregion

		#region Designer generated code

		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(FrmViewUpdatedPatients));
			this.grpPatients = new System.Windows.Forms.GroupBox();
			this.lblDeceasedPatients = new System.Windows.Forms.Label();
			this.lvPatients = new System.Windows.Forms.ListView();
			this.columnHeader4 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader1 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader5 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader2 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader10 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader11 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader6 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader3 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader8 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader9 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader7 = new System.Windows.Forms.ColumnHeader();
			this.btnClose = new System.Windows.Forms.Button();
			this.grpImage = new System.Windows.Forms.GroupBox();
			this.picImage = new System.Windows.Forms.PictureBox();
			this.grpPatients.SuspendLayout();
			this.grpImage.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(908, 30);
			this.vbecsLogo1.TabIndex = 2;
			this.vbecsLogo1.Title = "View Updated Patient List";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 357);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 4;
			// 
			// grpPatients
			// 
			this.grpPatients.AccessibleDescription = "Updated Patients with Active/Pending Orders";
			this.grpPatients.AccessibleName = "Updated Patients with Active/Pending Orders";
			this.grpPatients.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpPatients.Controls.Add(this.lblDeceasedPatients);
			this.grpPatients.Controls.Add(this.lvPatients);
			this.grpPatients.Location = new System.Drawing.Point(60, 32);
			this.grpPatients.Name = "grpPatients";
			this.grpPatients.Size = new System.Drawing.Size(844, 301);
			this.grpPatients.TabIndex = 1;
			this.grpPatients.TabStop = false;
			// 
			// lblDeceasedPatients
			// 
			this.lblDeceasedPatients.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lblDeceasedPatients.Location = new System.Drawing.Point(8, 12);
			this.lblDeceasedPatients.Name = "lblDeceasedPatients";
			this.lblDeceasedPatients.Size = new System.Drawing.Size(824, 16);
			this.lblDeceasedPatients.TabIndex = 0;
			this.lblDeceasedPatients.Text = "Updated Patients with Active/Pending Orders";
			this.lblDeceasedPatients.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lvPatients
			// 
			this.lvPatients.AccessibleDescription = "Updated Patients with Active/Pending Orders";
			this.lvPatients.AccessibleName = "Updated Patients with Active/Pending Orders";
			this.lvPatients.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lvPatients.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																						 this.columnHeader4,
																						 this.columnHeader1,
																						 this.columnHeader5,
																						 this.columnHeader2,
																						 this.columnHeader10,
																						 this.columnHeader11,
																						 this.columnHeader6,
																						 this.columnHeader3,
																						 this.columnHeader8,
																						 this.columnHeader9,
																						 this.columnHeader7});
			this.lvPatients.FullRowSelect = true;
			this.lvPatients.HideSelection = false;
			this.lvPatients.Location = new System.Drawing.Point(8, 32);
			this.lvPatients.MultiSelect = false;
			this.lvPatients.Name = "lvPatients";
			this.lvPatients.Size = new System.Drawing.Size(828, 261);
			this.lvPatients.TabIndex = 1;
			this.lvPatients.View = System.Windows.Forms.View.Details;
			this.lvPatients.ColumnClick += new System.Windows.Forms.ColumnClickEventHandler(this.lvPatients_ColumnClick);
			// 
			// columnHeader4
			// 
			this.columnHeader4.Text = "Patient Name";
			this.columnHeader4.Width = 185;
			// 
			// columnHeader1
			// 
			this.columnHeader1.Text = "Previous Name";
			this.columnHeader1.Width = 64;
			// 
			// columnHeader5
			// 
			this.columnHeader5.Text = "Patient ID";
			this.columnHeader5.Width = 80;
			// 
			// columnHeader2
			// 
			this.columnHeader2.Text = "Previous ID";
			this.columnHeader2.Width = 64;
			// 
			// columnHeader10
			// 
			this.columnHeader10.Text = "Patient Pseudo ID";
			this.columnHeader10.Width = 100;
			// 
			// columnHeader11
			// 
			this.columnHeader11.Text = "Previous Pseudo ID";
			this.columnHeader11.Width = 64;
			// 
			// columnHeader6
			// 
			this.columnHeader6.Text = "Patient DOB";
			this.columnHeader6.Width = 70;
			// 
			// columnHeader3
			// 
			this.columnHeader3.Text = "Previous DOB";
			this.columnHeader3.Width = 64;
			// 
			// columnHeader8
			// 
			this.columnHeader8.Text = "Sex";
			this.columnHeader8.Width = 55;
			// 
			// columnHeader9
			// 
			this.columnHeader9.Text = "Previous Sex";
			this.columnHeader9.Width = 67;
			// 
			// columnHeader7
			// 
			this.columnHeader7.Text = "Date Updated";
			this.columnHeader7.Width = 100;
			// 
			// btnClose
			// 
			this.btnClose.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnClose.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnClose.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnClose.Location = new System.Drawing.Point(828, 341);
			this.btnClose.Name = "btnClose";
			this.btnClose.TabIndex = 0;
			this.btnClose.Text = "&Close";
			this.btnClose.Click += new System.EventHandler(this.btnClose_Click);
			// 
			// grpImage
			// 
			this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpImage.Controls.Add(this.picImage);
			this.grpImage.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.grpImage.Location = new System.Drawing.Point(4, 32);
			this.grpImage.Name = "grpImage";
			this.grpImage.Size = new System.Drawing.Size(52, 301);
			this.grpImage.TabIndex = 3;
			this.grpImage.TabStop = false;
			// 
			// picImage
			// 
			this.picImage.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.picImage.Image = ((System.Drawing.Image)(resources.GetObject("picImage.Image")));
			this.picImage.Location = new System.Drawing.Point(4, 12);
			this.picImage.Name = "picImage";
			this.picImage.Size = new System.Drawing.Size(45, 45);
			this.picImage.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.picImage.TabIndex = 0;
			this.picImage.TabStop = false;
			// 
			// FrmViewUpdatedPatients
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnClose;
			this.ClientSize = new System.Drawing.Size(908, 373);
			this.Controls.Add(this.grpPatients);
			this.Controls.Add(this.btnClose);
			this.Controls.Add(this.grpImage);
			this.hlphelpChm.SetHelpKeyword(this, "Updated_Patients_and_Deceased_Patients.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MinimumSize = new System.Drawing.Size(750, 400);
			this.Name = "FrmViewUpdatedPatients";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - View Updated Patient List";
			this.Closing += new System.ComponentModel.CancelEventHandler(this.FrmViewUpdatedPatients_Closing);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.Controls.SetChildIndex(this.grpImage, 0);
			this.Controls.SetChildIndex(this.btnClose, 0);
			this.Controls.SetChildIndex(this.grpPatients, 0);
			this.grpPatients.ResumeLayout(false);
			this.grpImage.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		#region Constructors/Dispose

		/// <summary>
		/// Constructor
		/// </summary>
		public FrmViewUpdatedPatients()
		{
			InitializeComponent();
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC068.FrmViewUpdatedPatients());
			//
			LoadListView();
			//
			#region Set Default Column Widths
			
			// set default column widths to same as design
			this.columnHeader4.Width = 185;
			this.columnHeader1.Width = 64;
			this.columnHeader5.Width = 80;
			this.columnHeader2.Width = 64;
			this.columnHeader10.Width = 100;
			this.columnHeader11.Width = 64;
			this.columnHeader6.Width = 70;
			this.columnHeader3.Width = 64;
			this.columnHeader8.Width = 55;
			this.columnHeader9.Width = 67;
			this.columnHeader7.Width = 100;

			#endregion
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}
		#endregion

		#region Events / Event Handlers

		/// <summary>
		/// ViewedUpdates
		/// </summary>
		public event EventHandler ViewedUpdates
		{
			add
			{
				onViewedUpdates += value;
			}
			remove
			{
				onViewedUpdates -= value;
			}
		}

		/// <summary>
		/// OnViewedUpdates
		/// </summary>
		private void OnViewedUpdates(object sender, EventArgs e)
		{
			if (onViewedUpdates != null)
			{
				onViewedUpdates(this, e);
			}
		}

		/// <summary>
		/// btnClose_Click
		/// </summary>
		private void btnClose_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		/// <summary>
		/// FrmViewUpdatedPatients_Closing
		/// Implements BR_68.12
		/// </summary>
		private void FrmViewUpdatedPatients_Closing(object sender, CancelEventArgs e)
		{
			// Clear the alert icon
			OnViewedUpdates(null, EventArgs.Empty);
		}

		/// <summary>
		/// Sorts the list
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void lvPatients_ColumnClick(object sender, System.Windows.Forms.ColumnClickEventArgs e)
		{
			if (e.Column == 6 || e.Column == 7 || e.Column == 10)
			{
				controls.ColumnClickSorter.ColumnClickHandler(sender, e, false, controls.ColumnClickSorter.ColumnSortType.DateTime);
			}
			else 
			{
				controls.ColumnClickSorter.ColumnClickHandler(sender, e, false, controls.ColumnClickSorter.ColumnSortType.String);
			}
		}

		#endregion

		#region Methods

		/// <summary>
		/// LoadListView
		/// </summary>
		private void LoadListView()
		{
			PatientChange [] updatedPatientList = BOL.PatientChange.GetRecentlyUpdatedPatientDetails();
			if (updatedPatientList != null)
			{
				string currentDivision = Common.LogonUser.LogonUserDivisionCode; // CR 3164
				int recordCount = updatedPatientList.Length;
				if(recordCount > 0)
				{
					for (int idx = 0; idx < recordCount; idx++)
					{
						ListViewItem lVI = new ListViewItem();	
						//
						// Per SDD any changed items will display in bold text. 
						// For example, if the Patient ID changed, the previous ID will be populated and 
						// the Patient ID will be displayed in bold text. 
						lVI.UseItemStyleForSubItems = false;
						string toPatientName = Patient.BuildDisplayName(updatedPatientList[idx].ToPatientFirstName, updatedPatientList[idx].ToPatientMiddleName, updatedPatientList[idx].ToPatientLastName);
						string fromPatientName = Patient.BuildDisplayName(updatedPatientList[idx].FromPatientFirstName, updatedPatientList[idx].FromPatientMiddleName, updatedPatientList[idx].FromPatientLastName);
						//
						// Patient Name
						if(fromPatientName != toPatientName
							&& toPatientName != null
							&& toPatientName != string.Empty)
						{
							lVI.Text  = toPatientName;
							lVI.Font = new Font(this.lvPatients.Font, FontStyle.Bold);
							lVI.SubItems.Add(fromPatientName, lVI.ForeColor, lVI.BackColor, new Font(this.lvPatients.Font, FontStyle.Regular));
						}
						else
						{
							lVI.Text  = fromPatientName;
							lVI.SubItems.Add(" ");
						}
						//
						// Patient ID
						if(updatedPatientList[idx].FromPatientDisplayVistaPatientId != updatedPatientList[idx].ToPatientDisplayVistaPatientId 
							&& updatedPatientList[idx].ToPatientDisplayVistaPatientId != null
							&& updatedPatientList[idx].ToPatientDisplayVistaPatientId != string.Empty)
						{
							lVI.SubItems.Add(updatedPatientList[idx].ToPatientDisplayVistaPatientId, lVI.ForeColor, lVI.BackColor, new Font(this.lvPatients.Font, FontStyle.Bold));
							lVI.SubItems.Add(updatedPatientList[idx].FromPatientDisplayVistaPatientId, lVI.ForeColor, lVI.BackColor, new Font(this.lvPatients.Font, FontStyle.Regular));
						}
						else
						{
							lVI.SubItems.Add(updatedPatientList[idx].FromPatientDisplayVistaPatientId, lVI.ForeColor, lVI.BackColor, new Font(this.lvPatients.Font, FontStyle.Regular));
							lVI.SubItems.Add(" ");
						}
						//
						// Ssn Pseudo Indicator
						if(updatedPatientList[idx].FromSsnPseudoIndicator != updatedPatientList[idx].ToSsnPseudoIndicator)
						{
							lVI.SubItems.Add(Convert.ToString(updatedPatientList[idx].ToSsnPseudoIndicator), lVI.ForeColor, lVI.BackColor, new Font(this.lvPatients.Font, FontStyle.Bold));
							lVI.SubItems.Add(Convert.ToString(updatedPatientList[idx].FromSsnPseudoIndicator), lVI.ForeColor, lVI.BackColor, new Font(this.lvPatients.Font, FontStyle.Regular));
						}
						else
						{
							lVI.SubItems.Add(Convert.ToString(updatedPatientList[idx].FromSsnPseudoIndicator), lVI.ForeColor, lVI.BackColor, new Font(this.lvPatients.Font, FontStyle.Regular));
							lVI.SubItems.Add(" ");
						}
						//
						// Patient DOB
						if(updatedPatientList[idx].FromPatientDob != updatedPatientList[idx].ToPatientDob 
							&& updatedPatientList[idx].ToPatientDob != DateTime.MinValue)
						{
							lVI.SubItems.Add(Common.VBECSDateTime.FormatDateString(updatedPatientList[idx].ToPatientDob), lVI.ForeColor, lVI.BackColor, new Font(this.lvPatients.Font, FontStyle.Bold));
							lVI.SubItems.Add(Common.VBECSDateTime.FormatDateString(updatedPatientList[idx].FromPatientDob), lVI.ForeColor, lVI.BackColor, new Font(this.lvPatients.Font, FontStyle.Regular));
						}
						else
						{
							lVI.SubItems.Add(Common.VBECSDateTime.FormatDateString(updatedPatientList[idx].FromPatientDob), lVI.ForeColor, lVI.BackColor, new Font(this.lvPatients.Font, FontStyle.Regular));
							lVI.SubItems.Add(" ");
						}
						//
						// Sex
						if(updatedPatientList[idx].FromPatientSexCode != updatedPatientList[idx].ToPatientSexCode
							&& updatedPatientList[idx].ToPatientSexCode != null
							&& updatedPatientList[idx].ToPatientSexCode != string.Empty)
						{
							lVI.SubItems.Add(GetSexString(updatedPatientList[idx].ToPatientSexCode), lVI.ForeColor, lVI.BackColor, new Font(this.lvPatients.Font, FontStyle.Bold));
							lVI.SubItems.Add(GetSexString(updatedPatientList[idx].FromPatientSexCode), lVI.ForeColor, lVI.BackColor, new Font(this.lvPatients.Font, FontStyle.Regular));
						}
						else
						{
							lVI.SubItems.Add(GetSexString(updatedPatientList[idx].FromPatientSexCode), lVI.ForeColor, lVI.BackColor, new Font(this.lvPatients.Font, FontStyle.Regular));
							lVI.SubItems.Add(" ");
						}
						//					
						// Date Updated
						// CR 3043: use NotificationReceivedDate as UpdateDate; LastUpdateDate gets set when a record is viewed so does not
						// always accurately describe when the patient update was processed.
						lVI.SubItems.Add(Common.VBECSDateTime.FormatDateTimeString(updatedPatientList[idx].NotificationReceivedDate), lVI.ForeColor, lVI.BackColor, new Font(this.lvPatients.Font, FontStyle.Regular));
						//
						lVI.Tag = updatedPatientList[idx];
						//
						this.lvPatients.Items.Add(lVI);
						//
						if( updatedPatientList[idx].PatientChangeStatusCode != Common.PatientChangeStatus.SuccessfullyProcessed )
						{
							// CR 3164: we need to mark the records the user viewed as such, so they will not appear in the user alert;
							// to do this we add the current division code to updatedPatientList[idx].ActiveDivisions and update the DB.
							// We only update status to 'Successfully Processed' after at least one user in each division with an active 
							// order has viewed the update(s).
							ArrayList divisionsWithActiveOrdersList = null;
							if ( updatedPatientList[idx].DivisionsWithActiveOrders != null && updatedPatientList[idx].DivisionsWithActiveOrders.Length > 0 ) 
							{ 
								divisionsWithActiveOrdersList = new ArrayList( updatedPatientList[idx].DivisionsWithActiveOrders.Split(PatientChange.DivisionDelimiterSplitter) ); 
							}
							//
							ArrayList activeDivisionsAlertViewedList = null;
							if ( updatedPatientList[idx].ActiveDivisionsAlertViewed != null && updatedPatientList[idx].ActiveDivisionsAlertViewed.Length > 0 ) 
							{ 
								activeDivisionsAlertViewedList = new ArrayList( updatedPatientList[idx].ActiveDivisionsAlertViewed.Split(PatientChange.DivisionDelimiterSplitter) ); 
							}
							//
							if ( divisionsWithActiveOrdersList != null && divisionsWithActiveOrdersList.Count > 0 && divisionsWithActiveOrdersList.Contains(currentDivision)
								&& (activeDivisionsAlertViewedList != null && activeDivisionsAlertViewedList.Count > 0 && !activeDivisionsAlertViewedList.Contains(currentDivision)
								|| (activeDivisionsAlertViewedList == null || activeDivisionsAlertViewedList.Count == 0)) )
							{

								if ( activeDivisionsAlertViewedList == null ){ activeDivisionsAlertViewedList = new ArrayList(); }
								activeDivisionsAlertViewedList.Add(currentDivision); 
								//
								if ( updatedPatientList[idx].AllUpdatesViewed(activeDivisionsAlertViewedList, divisionsWithActiveOrdersList) )
								{
									updatedPatientList[idx].ActiveDivisionsAlertViewed = null;
									updatedPatientList[idx].PatientChangeStatusCode = Common.PatientChangeStatus.SuccessfullyProcessed;
								}
								else
								{
									updatedPatientList[idx].ActiveDivisionsAlertViewed = PatientChange.BuildAlertViewedString( currentDivision, activeDivisionsAlertViewedList );
								}
								//
								updatedPatientList[idx].UpdatePatientChangeStatus();

							} // end: if ( (activeDivisionsList != null ... 
						} // end: if(updatedPatientList[idx].PatientChangeStatusCode ...
					} // end: for (int idx = 0; idx < recordCount; idx++)
				} // end: if(recordCount > 0)
			} // end: if (updatedPatientList != null)
			else 
			{
				// No units found in database
				ListViewItem lvItem = new ListViewItem(Common.StrRes.SysErrMsg.Common.NoDataRowsFoundException("").ResString);
				this.lvPatients.Items.Add(lvItem);
				lvItem.Tag = null;
			}
			//
			controls.VbecsFunction.SetColumnWidths(this.lvPatients);
		}

		/// <summary>
		/// GetSexString
		/// </summary>
		public string GetSexString(string sexCode)
		{
			if (sexCode.Length == 0)
			{
				return sexCode;
			}
			return Common.Utility.GetSexEnumFromSexChar(Convert.ToChar(sexCode)).ToString();
		}

		#endregion
	}
}

